/******************************************************************************
*
*   File:       FitsFile.h
*   Version:    1.00
*   Author:     Jose Maria Panero Ciprian
*   Abstract:   include file for the C library for fits-file functions.
*
*
*   Revision History:
*       Date            Who   Version    Description
*   --------------------------------------------------------------------------
*       07/10/00        jmp     1.00    Initial
*
******************************************************************************/

#ifndef __boolean__
#define __boolean__
#define FALSE                   0
#define TRUE                    1
#define UNDEFINED               -1
#define ERROR                   -1
#define NO_ERROR                0
#endif
/*********************************************
*       end of the #ifndef __boolean__
*********************************************/

#ifndef FITSFILE_H
#define FITSFILE_H

#define MAX_FITS_CARD_LENGTH	40
#define MAX_FITS_HEADER_CARDS	36
#define FILL_DATA		(unsigned short)0
#define BITS_PER_BYTE		8
#define FITS_BLOCK_SIZE		2880

#define HEADER_DEFAULT_SIMPLE	(char *)"T"
#define HEADER_DEFAULT_BITPIX	(int)16
#define HEADER_DEFAULT_NAXIS	(int)2

/******************************************************************************
*       definition of fits header struct
******************************************************************************/
struct fits_header_struct
{
	char simple[1];
	int  bitpix;
	int  naxis;
	int  naxis1;
	int  naxis2;
	char date[MAX_FITS_CARD_LENGTH];
	char time[MAX_FITS_CARD_LENGTH];
	char location[MAX_FITS_CARD_LENGTH];
	char sidetime[MAX_FITS_CARD_LENGTH];
	char epoch[MAX_FITS_CARD_LENGTH];
	char airmass[MAX_FITS_CARD_LENGTH];
	int  exp_time;
	char img_type[MAX_FITS_CARD_LENGTH];
	char telescope[MAX_FITS_CARD_LENGTH];
	char instrment[MAX_FITS_CARD_LENGTH];
	char filter[MAX_FITS_CARD_LENGTH];
	char object[MAX_FITS_CARD_LENGTH];
	char ra[MAX_FITS_CARD_LENGTH];
	char dec[MAX_FITS_CARD_LENGTH];
	char observer[MAX_FITS_CARD_LENGTH];
	char comment1[MAX_FITS_CARD_LENGTH];
	char comment2[MAX_FITS_CARD_LENGTH];
	char comment3[MAX_FITS_CARD_LENGTH];
	char comment4[MAX_FITS_CARD_LENGTH];
};

/******************************************************************************
*       Function Prototypes
******************************************************************************/
int write_fits_file (const char *filename, int image_fd, 
					struct fits_header_struct fits_header);

int wirte_fits_header (int fd_out, struct fits_header_struct fits_header); 

int set_fits_header (struct fits_header_struct *fits_header);
int set_fits_header_time (struct fits_header_struct *fits_header);
int edit_fits_exposure_dimensions (struct fits_header_struct *fits_header, 
                                        int rows, int cols, int exp_time);


#endif
/*********************************************
*       end of the #ifndef FITSFILE_H
*********************************************/
/******************************************************************************
*
*		END OF CODE. FILE    FitsFile.h
*
******************************************************************************/
